<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <style>
        body {
            font-family: DejaVu Sans;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 6px;
        }

        .header {
            display: flex;
            justify-content: space-between;
        }

        .logo {
            width: 180px;
        }
    </style>
</head>

<body>

    <div class="header">
        <div>
            <img src="{{asset('assets/images/logo-dark.png')}}" class="logo">
            <h3>Project Measurement</h3>

            <p>
                Client: {{ $project->customer_name }}<br>
                Phone: {{ $project->customer_phone }}<br>
                Address: {{ $project->address }}

            </p>
        </div>

        <div>
            Order Date: {{ $project->order_date }}<br>
            Completion Date: {{ $project->expected_completion_date }}<br>
            Measured By: {{ $project->employee_name }}<br>

            Status: {{ $project->status }}
        </div>
    </div>

    <table>
        <tr>
            <th>Sl</th>
            <th>Size</th>
            <th>Room</th>
            <th>Item</th>
            <th>Catalog</th>
            <th>Serial</th>
            <th>Description</th>
        </tr>

        @php $sl = 1; @endphp

        @foreach($project->areas as $area)
        @foreach($area->items as $item)

        @if($item->measurement)

        <tr>
            <td>{{ $sl++ }}</td>

            <td>
                {{ $item->measurement->width }}
                x
                {{ $item->measurement->height }}
                {{ $item->measurement->unit }}
            </td>

            <td>{{ $area->area_name }}</td>

            <td>{{ ucfirst($item->category) }}</td>

            <td>
                {{ $item->curtain->catalogue ?? 
                   $item->wallpaper->catalogue ?? 
                   $item->sofa->fabric_catalogue ?? '' }}
            </td>

            <td>
                {{ $item->curtain->serial_no ??
                   $item->wallpaper->serial_no ??
                   $item->sofa->serial_no ?? '' }}
            </td>

            <td>{{ $item->notes }}</td>

        </tr>

        @endif

        @endforeach
        @endforeach

    </table>

</body>

</html>